<?php
$clientScript = Yii::app()->clientScript;
$clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/lib/jquery.flot.js');
$clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/lib/jquery.flot.categories.js');
$clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/admin/main.js');

$clientScript->registerScript('chart', <<<CHART_SCRIPT
$(function () {
	var data = new Array();
	var dataStanKonta = [];
	var dataObject = $dataJsObject;

	var statGraphData = colourBars(dataObject, data, function(prop, val) {
		if (prop != 'Stan konta')
			return [prop, val];
		else
			dataStanKonta.push([prop, val]);
	});

	//Display graph
	$.plot($("#placeholder1"), statGraphData, {
		grid:{
			hoverable:true
		},
		xaxis: {
			mode: "categories",
			tickLength: 0
		},
		bars: {
			show: true,
			barWidth: 0.2,
			order: 1,
		},
		legend: true,
	});

	//Display graph (Stan konta)
	$.plot($("#graphStanKonta"), [ dataStanKonta ], {
		grid:{
			hoverable:true
		},
		yaxis: {
			position: 'right',
			max: $model->maximumStanKonta*1.1
		},
		xaxis: {
			mode: "categories",
			tickLength: 0
		},
		bars: {
			show: true,
			barWidth: 0.2,
			order: 1,
		},
		legend: true,
	});

	//tooltip function
	function showTooltip(x, y, contents, areAbsoluteXY) {
		var rootElt = 'body';

		$('<div id="tooltip2" class="tooltip">' + contents + '</div>').css( {
			position: 'fixed',
			display: 'none',
			top: y - 35,
			left: x - 5,
			'z-index': '9999',
			'color': '#fff',
			'font-size': '11px',
			opacity: 0.8
		}).prependTo(rootElt).show();
	}

	function graphToolTip (event, pos, item) {
	    if (item) {
		if (previousPoint != item.datapoint) {
		    previousPoint = item.datapoint;

		    //delete de prГ©cГ©dente tooltip
		    $('.tooltip').remove();

		    var x = item.datapoint[0];

		    //All the bars concerning a same x value must display a tooltip with this value and not the shifted value
		    if(item.series.bars.order){
			for(var i=0; i < item.series.data.length; i++){
			    if(item.series.data[i][3] == item.datapoint[0])
				x = item.series.data[i][0];
			}
		    }

		    var y = item.datapoint[1];

		    showTooltip(item.pageX+5, item.pageY+5,"Punkty: " + y);

		}
	    }
	    else {
		$('.tooltip').remove();
		previousPoint = null;
	    }

	}

	//add tooltip event
	$("#placeholder1").bind("plothover", graphToolTip);

	$("#graphStanKonta").bind("plothover", graphToolTip);

});
CHART_SCRIPT
, CClientScript::POS_READY);
$this->breadcrumbs = array(
	'Statystyki'=>array('/teacher/main/statistics'),
	'Statystyki klasy '.$model->klasa->nazwa=>array('/teacher/main/statistics','classId'=>$model->klasa->id),
	'Statystyki firmy '.$model->nazwa
); ?>

<h1>Statystyki firmy <?php echo $model->nazwa ?></h1>

<div style="display:table;width:100%">
<div style="display:table-row;">
	<div style="display:table-cell;width:90%">
		<div class="bars" id="placeholder1"></div>
	</div>
	<div style="display:table-cell;width:40px">
		<div class="bars" id="graphStanKonta"></div>
	</div>
</div>
</div>

<?php
	$this->widget('zii.widgets.grid.CGridView', array(
		'id'=>'parametry-gry-grid',
		'dataProvider'=>$pointsDataProvider,
		'htmlOptions' => array('class' => 'tDefault'),
		'columns'=>array(
			array(
				'header'=>'Dziedzina',
				'value'=>'"<b>".$data["nazwa"]."</b>"',
				'type'=>'raw'
			),
			array(
				'name'=>'punkty',
				'header'=>'Punkty',
				'value'=>'$data["punkty"].($data["nazwa"]=="Stan konta"?" PLN":"")',
				'type'=>'raw'
			),
		),
	));
?>